﻿Imports System.Text
Imports System.Runtime.InteropServices
Public Class GPIB_CONTEC

    '(0)クラス内変数
    Public MyAddress As Integer = 0                                                     'マイアドレス
    Private DeviceAddress As Integer = 0                                                '機器アドレス
    Public MsgBuf As String = ""                                                        '受信データ
    Private gChCmd As GCHandle                                                          'Cmd配列用GCHandle

    'コンストラクター
    Public Sub New()
        'PinnedハンドルをCmdに分配する
        If gChCmd.IsAllocated = False Then
            gChCmd = GCHandle.Alloc(Cmd, GCHandleType.Pinned)
        End If
        'Pinnedハンドルでオブジェクトのアドレスを取得
        pCmd = gChCmd.AddrOfPinnedObject()
    End Sub

    '(1)接続
    Public Function OpenInterface(ByVal PrimaryAddress As String) As Boolean
        Dim mode As Integer
        Dim eoi As Integer
        Dim delim As Integer
        Dim message As String = ""
        Dim ret As Integer

        ret = GpibInit(message)                                                         'GPIB初期化
        If ret <> 0 Then
            MsgBox(message)
            Return False
        End If

        ret = GpBoardsts(&HAS, mode)                                                    'マスタ/スレーブモードの読み出し
        If ret <> 0 Then
            CheckRet("GpBoardsts", ret, message)                                        '戻り値をチェック
            MsgBox(message)
            Return False
        End If
        If mode <> 0 Then
            message = "This device is not MASTER. Please check your settings."
            MsgBox(message)
            Return False
        End If

        ret = GpBoardsts(&H8S, MyAddress)                                               'マイアドレスの取得
        If mode <> 0 Then
            CheckRet("GpBoardsts", ret, message)                                        '戻り値をチェック
            MsgBox(message)
            Return False
        End If

        eoi = 1                                                                         '0:使用しない / 1:使用する
        delim = 3                                                                       '0:未使用 / 1:CR+LF / 2:CR / 3:LF
        ret = GpDelim(delim, eoi)                                                       'デリミタコード(EOI)送出の設定
        If ret <> 0 Then
            CheckRet("GpDelim", ret, message)                                           '戻り値をチェック
            MsgBox(message)
            Return False
        End If

        ret = GpTimeout(10000)                                                          'タイムアウト設定
        If ret <> 0 Then
            CheckRet("GpTimeout", ret, message)                                         '戻り値をチェック
            MsgBox(message)
            Return False
        End If

        DeviceAddress = CInt(PrimaryAddress)

        Return True
    End Function

    '(2)切断
    Public Function CloseInterface() As Boolean
        GpibExit()                                                                      'GPIBの終了

        CloseInterface = True
    End Function

    '(3)コマンド送信
    Public Function SendMsg(ByVal strMsg As String) As Boolean
        Dim ret As Boolean = False

        ret = GpibPrint(DeviceAddress, strMsg)                                          '送信バッファに書き込み
        If ret <> 0 Then
            Return False
        End If

        Return True
    End Function

    '(4)受信
    Public Function ReceiveMsg(ByVal timeout_ms As Long) As Boolean
        Dim message As String = ""
        Dim buf As New StringBuilder(8388608)
        Dim ret As Integer

        ret = GpTimeout(timeout_ms)                                                     'タイムアウト設定
        If ret <> 0 Then
            CheckRet("GpTimeout", ret, Message)                                         '戻り値をチェック
            MsgBox(Message)
            Return False
        End If

        ret = GpibInputHioki(DeviceAddress, buf)                                        '受信バッファに読み込み
        If ret <> 0 Then
            MsgBuf = "Error"
            Return False
        End If
        MsgBuf = buf.ToString()                                                         '受信データを保存

        Return True

    End Function

    '(5)コマンド送受信
    Public Function SendQueryMsg(ByVal strMsg As String, ByVal timeout_ms As Long) As Boolean
        Dim buf As New StringBuilder(8388608)
        Dim ret As Boolean = False

        'GPIB.ReadString()                                                              '受信バッファにデータがあれば読み取り

        ret = SendMsg(strMsg)                                                           'コマンド送信
        If ret Then
            If InStr(strMsg, "?") <> 0 Then
                ret = ReceiveMsg(timeout_ms)                                            '送信が成功したら応答を受信
            End If
        End If

        SendQueryMsg = ret
    End Function


End Class
